
################################################################################
# floppySaveDialogCreate() - creates the Save dialog
################################################################################
proc floppySaveDialogCreate {} {
    global fsformat
    global tosvdFormats
    global floppyCurrent

    iwidgets::dialogshell .fs -title "Select Filename and Type"

    .fs add OK -text "OK" -command { 
	set fsfile [[.fs childsite].file childsite]
	set filename [$fsfile.name get]

	if [floppySaveExecute .fs $floppyCurrent $filename $fsformat] {
	    .fs deactivate
	    set floppyLastSave 1
	}
    }
    .fs default OK
    .fs add cancel -text "Cancel" -command { .fs deactivate
                                             set floppyLastSave 0 }

    .fs add help -text "Help" -command { 
	tk_messageBox -default ok -icon info -title "Help" -type ok -message \
"In this dialog, you choose what file to save
a floppy image into.  You can also
choose the format for saving the file." }

    .fs configure -modality application

    set fswin [.fs childsite]

    iwidgets::Labeledframe $fswin.file -labelpos nw -labeltext "Filename"
    set fsfile [$fswin.file childsite]

    iwidgets::entryfield $fsfile.name \
	    -highlightthickness 0 \
	    -labelpos w \
	    -labeltext "Image file:" \
	    -textbackground "white" \
	    -width 30

    [$fsfile.name component label] configure -justify left -underline 0

    button $fsfile.browse -text "Browse..." \
	    -command { 
	         set fsfile [[.fs childsite].file childsite]
	         set newfile [floppyFilesBrowseImage .fs "new" ]
		 if {$newfile != "" } {
		     $fsfile.name delete 0 end
		     $fsfile.name insert 0 $newfile
		     $fsfile.name xview moveto 1
		 }
	     }

    pack $fsfile.name -side left -anchor e -padx 3 -pady 3
    pack $fsfile.browse -side right -anchor w -padx 3 -pady 3

    iwidgets::Labeledframe $fswin.format -labelpos nw -labeltext "Output Format"
    set fsformat [$fswin.format childsite]

    set tosvdFormats [tosvdFormatsSupported]

    # remember to put a warning at the top about file formats...

    foreach formatlist $tosvdFormats {
	set format [lindex $formatlist 0]
	set description [lindex $formatlist 1]
	radiobutton $fsformat.[string tolower $format] -text $description \
		-variable fsformat -value $format
	pack $fsformat.[string tolower $format] -side top -anchor w
    }

    pack $fswin.file -side top -expand no -anchor n -fill x
    pack $fswin.format -side bottom -expand no -anchor n -fill x
}


################################################################################
# floppySave() - called to cause a save of a floppy image.
#                  The floppy to save is given as the argument.
################################################################################
proc floppySave {num} {
    global fsformat
    global OSListFile
    global tosvdFormats
    global floppyLastSave

    global floppyLoaded
    global floppyType
    global floppyFiles
    global floppyImage
    global floppyEnabled
    global floppyProtected
    global floppyFilesOS
    global floppyMemoryUsed
    global floppyCurrent

    set floppyCurrent $num

    set fsformat ""

    #
    # this tricky little code tries to set the extension to
    # something that make sense for the current device
    #
    if [info exists OSListFile] {
	foreach formatlist $tosvdFormats {
	    set format [lindex $formatlist 0]
	    set description [lindex $formatlist 1]
	    if { [lsearch $OSListFile(exts) ".[string tolower $format]"] != -1 } {
		set fsformat $format
	    }
	}
    }

    if { $fsformat == "" } {
	set fsformat "SVD"
    }

    .fs configure -title "Select filename and type to save Disk $floppyCurrent"
    .fs activate

    return $floppyLastSave
}

################################################################################
# floppySaveExecute() - perform the saving now that things are set.
################################################################################
proc floppySaveExecute {win num filename format} {
    global floppyType
    global floppyImage
    global floppyUploadFile

    if { $filename == "" } {
	tk_messageBox -default ok -icon error -title "ERROR"  \
		-parent $win -type ok -message "You must enter a filename."
	return 0
    }

    if { [file readable $filename] } {
	set answer [tk_messageBox -default no -icon warning -title "WARNING"  \
	              -type yesno -parent $win -message \
"That file already exists.  Last
chance, are you sure you want to
overwrite it?"]
	if { $answer != "yes" } {
	    return 0
	}
    }

    set cmd [floppyConvCmdCompose $num $format $filename]
    workingMessagePopUp "Saving...please wait..." $win
    eval exec $cmd
    workingMessageRemove

    # first delete the temporary file if we have an upload
    
    if { $floppyType($num) == "upload" } {
	file delete $floppyUploadFile($num)
    }

    # now that we have a saved file, convert the type of the $num disk
    # to an image and put everything where it should be (most stuff is
    # just fine anyway)...

    set floppyType($num) "image"
    set floppyImage($num) $filename

    # make sure the name is up under the floppy picture

    floppyGuiEnable $num

    return 1
}

